const modalGambar = $("#m_edit_gambar");
const modalGambarBody = modalGambar.find('#m_body');
const wrapImages = $('#wrap_images');
const itemImgOutput = $('#item-img-output');
const cropArea = $('#upload-gambar');

$(document).ready(function () {
  $('#file_input').on('change', function () {
    tempFilename = $(this).val();
    readFile(this);
    let btnCrop = modalGambar.find('.btn_m_crop');
    if (btnCrop.length > 0) {
      btnCrop.prop('id', 'cropImageBtn');
    }
  });
});

function readFile(input) {
  if (input.files && input.files[0]) {
    let reader = new FileReader();
    reader.onload = function (e) {
      let rawImg = e.target.result;
      modalGambar.modal({
        closable: false,
        onShow: function () {
          cropArea.croppie({
            viewport: {
              width: 800,
              height: 320,
            },
            enableOrientation: true,
          });
          cropArea.addClass('ready');
        },
        onVisible: function () {
          cropArea.croppie('bind', {
            url: rawImg
          }).then(function () {
            console.log('jQuery bind complete');
          });
        },
        onHide: function () {
          cropArea.croppie('destroy');
        }
      }).modal('show');
    }
    reader.readAsDataURL(input.files[0]);
  }
}

modalGambar.on('click', '#cropImageBtn', function (ev) {
  cropArea.croppie('result', {
    type: 'base64',
  }).then(function (resp) {
    wrapImages.find('#image_items').val(resp).trigger('change');
    wrapImages.find('img').attr('src', resp)
    modalGambar.modal('hide');
  });
});