$('.slider input').on('input change', function() {
	let h = $('.slider-h input').val() / 100;
	let s = $('.slider-s input').val() / 100;
	let l = $('.slider-l input').val() / 100;
	let hColor = 'HSL(' + h * 360 + ', 100%, 50%)';
	let sColor = 'HSL(' + h * 360 + ',' + s * 100 + '%, 50%)';
	let hsl = 'HSL(' + h * 360 + ',' + s * 100 + '%,' + l * 100 + '%)';
	
	$('.slider-h .thumb').css({
		left: h * 18.8 +'rem',
		background: hColor
	})
	
	$('.slider-s .thumb').css({
		left: s * 18.8 +'rem',
		background: sColor
	})
	
	$('.slider-l .thumb').css({
		left: l * 18.8 +'rem',
		background: hsl
	})
	
	$('.slider-s input').css({
		backgroundColor: hColor
	})
	
	$('.slider-l input').css({
		backgroundColor: sColor
	})
	
	$('.color-preview').css({
		backgroundColor: hsl
	})
	
	$('.hex-code .code').text(HSLtoHEX(h, s, l))
})

function HSLtoHEX(h,s,l) {
	h *= 360;
	
	let c = (1 - Math.abs(2 * l - 1)) * s,
			x = c * (1 - Math.abs((h / 60) % 2 - 1)),
			m = l - c/2,
			r = 0,
			g = 0,
			b = 0;
	
	if (0 <= h && h < 60) {
    r = c; g = x; b = 0;
  } else if (60 <= h && h < 120) {
    r = x; g = c; b = 0;
  } else if (120 <= h && h < 180) {
    r = 0; g = c; b = x;
  } else if (180 <= h && h < 240) {
    r = 0; g = x; b = c;
  } else if (240 <= h && h < 300) {
    r = x; g = 0; b = c;
  } else if (300 <= h && h < 360) {
    r = c; g = 0; b = x;
  }
  r = Math.round((r + m) * 255);
  g = Math.round((g + m) * 255);
  b = Math.round((b + m) * 255);

  r = r.toString(16);
  g = g.toString(16);
  b = b.toString(16);

  if (r.length == 1)
    r = "0" + r;
  if (g.length == 1)
    g = "0" + g;
  if (b.length == 1)
    b = "0" + b;

  return "#" + r + g + b;
}