const frame = document.getElementById('winterFrame');
const lightsContainer = document.getElementById('lights');
const ornamentsContainer = document.getElementById('ornaments');
    
const lightColors = [
    '#ff6b8b',
    '#7bed9f',
    '#70a1ff',
    '#ffd700',
    '#ff7f50',
    '#9b59b6',
    '#1dd1a1'
];
    
const ornamentSets = [
    { color: '#c41e3a', light: '#ff4757', glow: 'rgba(196, 30, 58, 0.6)' },
    { color: '#d4af37', light: '#ffd700', glow: 'rgba(212, 175, 55, 0.6)' },
    { color: '#0066cc', light: '#3742fa', glow: 'rgba(0, 102, 204, 0.6)' },
    { color: '#2ecc71', light: '#2ed573', glow: 'rgba(46, 204, 113, 0.6)' },
    { color: '#c0c0c0', light: '#e8e8e8', glow: 'rgba(192, 192, 192, 0.6)' }
];

// snowfall
const createSnowflakes = () => {
    for (let i = 0; i < 80; i++) {
        const snow = document.createElement('div');
        snow.className = 'snowflake';
        
        const size = Math.random() * 3.5 + 1.5;
        snow.style.width = size + 'px';
        snow.style.height = size + 'px';
        snow.style.left = Math.random() * 100 + '%';
        snow.style.top = -Math.random() * 100 + 'px';
        snow.style.opacity = Math.random() * 0.6 + 0.4;
        
        const duration = Math.random() * 3 + 6;
        const delay = Math.random() * 8000;
        const sway = (Math.random() - 0.5) * 40;
        
        snow.animate([
            { transform: 'translateY(0) translateX(0)', opacity: 0 },
            { transform: `translateY(250px) translateX(${sway * 0.5}px)`, opacity: 1, offset: 0.3 },
            { transform: `translateY(520px) translateX(${sway}px)`, opacity: 0 }
        ], {
            duration: duration * 1000,
            iterations: Infinity,
            delay: delay,
            easing: 'cubic-bezier(0.4, 0, 0.2, 1)'
        });
        
        frame.appendChild(snow);
    }
};

const createLights = () => {
    setTimeout(() => {
    for (let i = 0; i < 60; i++) {
        const light = document.createElement('div');
        light.className = 'light';

        const y = Math.random() * 250; 
        let maxWidth;

        if (y < 75) {
            maxWidth = (y / 75) * 45;
        } else if (y < 160) {
            maxWidth = ((y - 30) / 130) * 80;
        } else {
            maxWidth = ((y - 80) / 170) * 115;
        }

        const x = (Math.random() * 2 - 1) * maxWidth;

        light.style.top = y + 'px';
        light.style.left = x + 'px';
        light.style.backgroundColor = lightColors[Math.floor(Math.random() * lightColors.length)];
        light.style.setProperty('--glow-color', light.style.backgroundColor);
        
        light.style.setProperty('--t-speed', (Math.random() * 1.2 + 0.6) + 's');
        light.style.animationDelay = (Math.random() * 2) + 's';
        
        lightsContainer.appendChild(light);
    }
}, 2200);
};

    
const createOrnaments = () => {
    setTimeout(() => {
        const positions = [
            { y: [35, 80], maxWidth: 30, count: 5 },
            { y: [80, 160], maxWidth: 60, count: 7 },
            { y: [160, 240], maxWidth: 85, count: 8 }
        ];

    positions.forEach(pos => {
        for (let i = 0; i < pos.count; i++) {
        const ornament = document.createElement('div');
        ornament.className = 'ornament';
            
        const y = Math.random() * (pos.y[1] - pos.y[0]) + pos.y[0];
        const normalizedY = (y - pos.y[0]) / (pos.y[1] - pos.y[0]);
        const maxWidth = pos.maxWidth * normalizedY;
        const x = (Math.random() * 2 - 1) * maxWidth;

        ornament.style.top = y + 'px';
        ornament.style.left = x + 'px';
            
        const colorSet = ornamentSets[Math.floor(Math.random() * ornamentSets.length)];
        ornament.style.setProperty('--ornament-color', colorSet.color);
        ornament.style.setProperty('--ornament-light', colorSet.light);
        ornament.style.setProperty('--ornament-glow', colorSet.glow);
        ornament.style.setProperty('--swing-speed', (Math.random() * 2 + 3.5) + 's');
        ornament.style.animationDelay = (Math.random() * 1.8 + (pos.y[0] / 150)) + 's';
            
        ornamentsContainer.appendChild(ornament);
    }
});
}, 2500);
};

const createStars = () => {
    for (let i = 0; i < 40; i++) {
    const star = document.createElement('div');
    star.style.position = 'absolute';
    star.style.width = Math.random() * 2 + 0.5 + 'px';
    star.style.height = star.style.width;
    star.style.background = '#ffffff';
    star.style.borderRadius = '50%';
    star.style.left = Math.random() * 100 + '%';
    star.style.top = Math.random() * 70 + '%';
    star.style.opacity = Math.random() * 0.4 + 0.2;
    star.style.boxShadow = `0 0 ${Math.random() * 3 + 2}px rgba(255, 255, 255, 0.8)`;
    star.style.animation = `twinkle ${Math.random() * 3 + 2}s infinite alternate`;
    star.style.animationDelay = Math.random() * 2 + 's';
        
    frame.appendChild(star);
}
};

createSnowflakes();
createLights();
createOrnaments();
createStars();