const interactiveZone = document.getElementById("interactiveZone");
const customCursor = document.getElementById("customCursor");
const cursorInner = document.getElementById("cursorInner");
const thumbnailContainer = document.getElementById("thumbnailContainer");
const videoContainer = document.getElementById("videoContainer");
const videoPlayer = document.getElementById("videoPlayer");

let isInZone = false;
let isPlaying = false;

// Activate custom cursor when entering interactive zone
interactiveZone.addEventListener("mouseenter", () => {
  if (!isPlaying) {
    isInZone = true;
    customCursor.classList.add("active");
    interactiveZone.classList.add("cursor-active");
  }
});

// Deactivate custom cursor when leaving interactive zone
interactiveZone.addEventListener("mouseleave", () => {
  isInZone = false;
  customCursor.classList.remove("active");
  interactiveZone.classList.remove("cursor-active");
});

// Update cursor position on mouse move
document.addEventListener("mousemove", e => {
  if (isInZone && !isPlaying) {
    customCursor.style.left = `${e.clientX}px`;
    customCursor.style.top = `${e.clientY}px`;
  }
});

// Create ripple effect
const createRipple = e => {
  const ripple = document.createElement("span");
  ripple.classList.add("ripple");
  const rect = interactiveZone.getBoundingClientRect();
  const size = 80;
  const x = e.clientX - rect.left - size / 2;
  const y = e.clientY - rect.top - size / 2;
  ripple.style.left = `${x}px`;
  ripple.style.top = `${y}px`;
  ripple.style.width = `${size}px`;
  ripple.style.height = `${size}px`;

  // Add to interactive zone, not thumbnail container
  interactiveZone.appendChild(ripple);

  // Log to console for debugging
  console.log("Ripple created at:", x, y);

  setTimeout(() => ripple.remove(), 800);
};

// Handle click in interactive zone (only when thumbnail is visible)
interactiveZone.addEventListener("click", e => {
  if (!isPlaying) {
    // Add click animation to cursor
    cursorInner.classList.add("clicked");
    setTimeout(() => cursorInner.classList.remove("clicked"), 300);

    // Create ripple effect FIRST
    createRipple(e);

    // Delay video start slightly so ripple is visible
    setTimeout(() => {
      playVideo();
    }, 200);
  }
});

// Play video function
const playVideo = () => {
  isPlaying = true;
  isInZone = false;

  // Hide custom cursor and thumbnail
  customCursor.classList.remove("active");
  thumbnailContainer.classList.add("hidden");

  // Show embedded video player
  videoContainer.classList.add("active");
  interactiveZone.classList.add("playing");

  // Start playback
  videoPlayer.play();
};