// Simple script for mobile nav, matrix background and contact form handling
document.addEventListener('DOMContentLoaded', () => {
  // NAV TOGGLE
  const navToggle = document.getElementById('nav-toggle');
  const navList = document.getElementById('nav-list');
  if (navToggle && navList) {
    navToggle.addEventListener('click', () => {
      const open = navList.classList.toggle('open');
      navToggle.setAttribute('aria-expanded', String(open));
    });
  }

  // Contact form fake submit
  const form = document.getElementById('contact-form');
  const status = document.getElementById('form-status');
  if (form) {
    form.addEventListener('submit', (e) => {
      e.preventDefault();
      status.textContent = 'Sende Nachricht…';
      // Simuliere API-Aufruf
      setTimeout(() => {
        status.textContent = 'Danke! Nachricht gesendet (Demo).';
        form.reset();
      }, 900);
    });
  }

  // MATRIX CANVAS EFFECT
  const canvas = document.getElementById('matrix');
  if (canvas && canvas.getContext) {
    const ctx = canvas.getContext('2d');
    let width = canvas.width = window.innerWidth;
    let height = canvas.height = window.innerHeight;
    const letters = '01αβγδεζηθικλμνξοπρστυφχψω<>/{}[]()@#%&0123456789';
    const fontSize = Math.max(10, Math.floor(Math.min(width, height) / 60));
    const columns = Math.floor(width / fontSize);
    const drops = new Array(columns).fill(1);

    function draw() {
      ctx.fillStyle = 'rgba(7,16,23,0.08)';
      ctx.fillRect(0, 0, width, height);
      ctx.fillStyle = 'rgba(0,255,138,0.9)';
      ctx.font = fontSize + 'px monospace';

      for (let i = 0; i < drops.length; i++) {
        const text = letters.charAt(Math.floor(Math.random() * letters.length));
        ctx.fillText(text, i * fontSize, drops[i] * fontSize);
        if (drops[i] * fontSize > height && Math.random() > 0.975) {
          drops[i] = 0;
        }
        drops[i]++;
      }
      requestAnimationFrame(draw);
    }

    draw();

    // Resize handling
    window.addEventListener('resize', () => {
      width = canvas.width = window.innerWidth;
      height = canvas.height = window.innerHeight;
    });
  }

  // Small accessibility enhancement: highlight active nav by path
  const links = document.querySelectorAll('.nav-list a');
  links.forEach(a => {
    try {
      const href = a.getAttribute('href');
      if (href && location.pathname.endsWith(href)) {
        a.classList.add('active');
      }
    } catch (e) {}
  });
});