document.addEventListener("DOMContentLoaded", () => {
  const video = document.getElementById("bg-video");

  // Fade-in when video is fully buffered and ready to play through
  function enableFadeIn() {
    video.addEventListener("canplaythrough", () => {
      video.style.opacity = "1";
    });
  }

  if ("IntersectionObserver" in window) {
    const observer = new IntersectionObserver((entries, obs) => {
      entries.forEach((entry) => {
        if (entry.isIntersecting) {
          video.load();
          video.play();
          enableFadeIn(); // Attach listener after load
          obs.unobserve(entry.target);
        }
      });
    });
    observer.observe(video);
  } else {
    // Fallback for older browsers
    video.load();
    video.play();
    enableFadeIn();
  }
});