(function () {
  const translations = {
    de: {
      title: "Datenschutzeinstellungen",
      intro: "Wir verwenden Cookies und binden externe Dienste ein. Sie können selbst entscheiden, welche Dienste Sie erlauben. Weitere Informationen finden Sie in unserer <a href='/datenschutz' target='_blank'>Datenschutzerklärung</a>.",
      youtube: "YouTube Inhalte laden",
      maps: "Google Maps anzeigen",
      ads: "Google Werbung anzeigen",
      accept: "Speichern",
      reject: "Nur notwendige",
      all: "Alle akzeptieren",
      toggle: "Cookie-Einstellungen",
      yt_blocked: "🎬 YouTube-Inhalt blockiert. Bitte Cookies akzeptieren.",
      maps_blocked: "🗺️ Google Maps ist blockiert. Bitte Cookies akzeptieren.",
      ads_blocked: "🛑 Google Werbung ist blockiert. Bitte Cookies akzeptieren."
    },
    en: {
      title: "Privacy Settings",
      intro: "We use cookies and embed external services. You can decide which services to allow. For more information, see our <a href='/privacy' target='_blank'>privacy policy</a>.",
      youtube: "Load YouTube content",
      maps: "Show Google Maps",
      ads: "Show Google Ads",
      accept: "Save selection",
      reject: "Only essential",
      all: "Accept all",
      toggle: "Cookie settings",
      yt_blocked: "🎬 YouTube content blocked. Please accept cookies.",
      maps_blocked: "🗺️ Google Maps is blocked. Please accept cookies.",
      ads_blocked: "🛑 Google Ads are blocked. Please accept cookies."
    }
  };
  const lang = (navigator.language || "de").substring(0, 2);
  const t = translations[lang] ? translations[lang] : translations["de"];

  const style = `
    :root {
      --primary: #2563eb;
      --success: #10b981;
      --gray-100: #f3f4f6;
      --gray-700: #374151;
      --gray-900: #111827;
      --overlay-bg: rgba(30, 32, 39, 0.75);
    }
    .cookie-toggle {
      position: fixed;
      bottom: 20px;
      right: 20px;
      background-color: var(--primary);
      color: white;
      border: none;
      padding: 0.75rem 1.25rem;
      border-radius: 50px;
      font-weight: bold;
      cursor: pointer;
      z-index: 10001;
    }
    .cookie-overlay {
      display: none;
      position: fixed;
      z-index: 9998;
      left: 0; top: 0; right: 0; bottom: 0;
      width: 100vw; height: 100vh;
      background: var(--overlay-bg);
      transition: background 0.4s;
      backdrop-filter: blur(1px);
    }
    .cookie-overlay.visible {
      display: block;
    }
    .cookie-banner-center-wrapper {
      display: none;
      align-items: center;
      justify-content: center;
      position: fixed;
      z-index: 9999;
      left: 0; top: 0; right: 0; bottom: 0;
      width: 100vw; height: 100vh;
      pointer-events: none;
    }
    .cookie-banner-center-wrapper.visible {
      display: flex;
      pointer-events: auto;
    }
    .cookie-banner {
      background: white;
      border-radius: 1rem;
      padding: 2rem 1.5rem 1.5rem 1.5rem;
      max-width: 420px;
      width: 95vw;
      text-align: left;
      box-shadow: 0 2px 32px rgba(0,0,0,0.25);
      font-family:arial;
      position: relative;
      animation: bannerIn 0.5s;
      z-index: 10000;
      pointer-events: auto;
    }
    @keyframes bannerIn {
      0% { transform: scale(0.95) translateY(40px); opacity: 0; }
      100% { transform: scale(1) translateY(0); opacity: 1;}
    }
    .cookie-banner h3 {
      margin-top: 0;
      font-size: 1.1rem;
      color: var(--gray-900);
    }
    .cookie-banner p {
      font-size: 0.99rem;
      color: var(--gray-700);
    }
    .checkboxes { margin-top: 1rem; margin-bottom: 1.3rem;}
    .checkboxes label {
      display: block; margin-bottom: 0.75rem; color: var(--gray-700);
    }
    .checkboxes input { margin-right: 0.5rem; transform: scale(1.2);}
    .button-row {
      display: flex; justify-content: space-between; gap: 0.5rem; flex-wrap: wrap;
    }
    .btn {
      padding: 0.6rem 1rem; border-radius: 0.5rem; border: none; font-weight: 600; cursor: pointer; flex: 1;
      margin-top: 0.3rem;
    }
    .btn-accept { background-color: var(--success); color: white;}
    .btn-reject { background-color: var(--gray-100); color: var(--gray-900);}
    .btn-all { background-color: var(--primary); color: white;}
    .placeholder {
      background: var(--gray-100); color: var(--gray-700); text-align: center; padding: 1.25rem; margin: 2rem auto;
      border-radius: 0.75rem; width: 90%; max-width: 600px; box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    }
    iframe {
      display: block; margin: 2rem auto; border-radius: 0.75rem; width: 90%; max-width: 600px; border: none;
    }
    .ads-container { margin: 2rem auto; width: 90%; max-width: 600px;}
    @media (max-width: 600px) {
      .cookie-banner { padding: 1.2rem 0.6rem 1rem 0.6rem; }
    }
  `;

  const html = `
    <button class="cookie-toggle" onclick="toggleBanner()">${t.toggle}</button>
    <div id="cookie-overlay" class="cookie-overlay"></div>
    <div id="cookie-banner-center-wrapper" class="cookie-banner-center-wrapper">
      <div id="cookie-banner" class="cookie-banner" role="dialog" aria-modal="true" aria-labelledby="cookieTitle">
        <h3 id="cookieTitle">${t.title}</h3>
        <p>${t.intro}</p>
        <div class="checkboxes">
          <label><input type="checkbox" id="acceptYouTube" checked /> ${t.youtube}</label>
          <label><input type="checkbox" id="acceptMaps" checked /> ${t.maps}</label>
          <label><input type="checkbox" id="acceptAds" checked /> ${t.ads}</label>
        </div>
        <div class="button-row">
          <button class="btn btn-reject" onclick="rejectCookies()">${t.reject}</button>
          <button class="btn btn-accept" onclick="acceptCookies()">${t.accept}</button>
          <button class="btn btn-all" onclick="acceptAllCookies()">${t.all}</button>
        </div>
      </div>
    </div>
    <div id="youtube-container" class="placeholder">${t.yt_blocked}</div>
    <div id="maps-container" class="placeholder">${t.maps_blocked}</div>
    <div id="ads-container" class="placeholder ads-container">${t.ads_blocked}</div>
  `;

  const styleTag = document.createElement("style");
  styleTag.innerHTML = style;
  document.head.appendChild(styleTag);

  const wrapper = document.createElement("div");
  wrapper.innerHTML = html;
  document.body.appendChild(wrapper);

  function showBanner() {
    document.getElementById('cookie-overlay').classList.add('visible');
    document.getElementById('cookie-banner-center-wrapper').classList.add('visible');
    // Standardmäßig alles checked setzen (auch falls localStorage schon existiert)
    document.getElementById('acceptYouTube').checked = true;
    document.getElementById('acceptMaps').checked = true;
    document.getElementById('acceptAds').checked = true;
  }
  function hideBanner() {
    document.getElementById('cookie-overlay').classList.remove('visible');
    document.getElementById('cookie-banner-center-wrapper').classList.remove('visible');
  }

  window.toggleBanner = function () {
    if(document.getElementById('cookie-banner-center-wrapper').classList.contains('visible')) {
      hideBanner();
    } else {
      showBanner();
    }
  };

  window.acceptCookies = function () {
    const prefs = {
      youtube: document.getElementById('acceptYouTube').checked,
      maps: document.getElementById('acceptMaps').checked,
      ads: document.getElementById('acceptAds').checked
    };
    localStorage.setItem('cookiePrefs', JSON.stringify(prefs));
    hideBanner();
    loadIframes(prefs);
  };

  window.rejectCookies = function () {
    const prefs = { youtube: false, maps: false, ads: false };
    document.getElementById('acceptYouTube').checked = false;
    document.getElementById('acceptMaps').checked = false;
    document.getElementById('acceptAds').checked = false;
    localStorage.setItem('cookiePrefs', JSON.stringify(prefs));
    hideBanner();
    loadIframes(prefs);
  };

  window.acceptAllCookies = function () {
    document.getElementById('acceptYouTube').checked = true;
    document.getElementById('acceptMaps').checked = true;
    document.getElementById('acceptAds').checked = true;
    window.acceptCookies();
  };

  function loadIframes(prefs) {
    const yt = document.getElementById('youtube-container');
    const maps = document.getElementById('maps-container');
    const ads = document.getElementById('ads-container');

    // YouTube
    if (prefs.youtube) {
      yt.innerHTML = `<iframe width="560" height="315" src="https://www.youtube-nocookie.com/embed/dQw4w9WgXcQ" title="YouTube Video" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>`;
    } else {
      yt.innerHTML = t.yt_blocked;
    }

    // Maps
    if (prefs.maps) {
      maps.innerHTML = `<iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2429.747033474372!2d13.404954215805627!3d52.520006279812556!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x47a851c217b9b79f%3A0xf419ed56f39b0c3f!2sBerlin!5e0!3m2!1sde!2sde!4v1621274028891!5m2!1sde!2sde" width="600" height="450" allowfullscreen loading="lazy"></iframe>`;
    } else {
      maps.innerHTML = t.maps_blocked;
    }

    // Google Werbung
    if (prefs.ads) {
      ads.innerHTML = `
        <ins class="adsbygoogle"
          style="display:block"
          data-ad-client="ca-pub-XXXXXXXXXXXXXXXX"
          data-ad-slot="1234567890"
          data-ad-format="auto"></ins>
        <script>
          (adsbygoogle = window.adsbygoogle || []).push({});
        </script>
      `;
      if (window.adsbygoogle && Array.isArray(window.adsbygoogle)) {
        window.adsbygoogle.push({});
      }
    } else {
      ads.innerHTML = t.ads_blocked;
    }
  }

  document.addEventListener("DOMContentLoaded", () => {
    // Immer Banner direkt zeigen, mit allen Checkboxen checked
    showBanner();
    // Falls der Nutzer schon gewählt hat, Inhalte laden
    const prefs = JSON.parse(localStorage.getItem('cookiePrefs') || '{"youtube":true,"maps":true,"ads":true}');
    loadIframes({
      youtube: prefs.youtube === true,
      maps: prefs.maps === true,
      ads: prefs.ads === true
    });
  });
})();