//
//  koby.dev | 2022
//  twitter: @builtbymax
//  instagram: @koby.dev
//

import * as pokeapiJsWrapper from "https://cdn.skypack.dev/pokeapi-js-wrapper@1.2.2";
const P = new pokeapiJsWrapper.Pokedex();

function pageReady(callback) {
  if (document.readyState !== "loading") {
    callback();
  } else document.addEventListener("DOMContentLoaded", callback);
}

const Pokemon = {
  init: () => {
    Pokemon.getRandomPokemon();
    Pokemon.getNewTeaser();
  },

  getNewTeaser: () => {
    const button = document.querySelector(".button-container button");
    button.addEventListener("click", () => {
      document.querySelector(".pokemon-col").innerHTML = "";
      Pokemon.getRandomPokemon();
    });
  },

  createPokemonTeaserElement: data => {
    const colBlock = document.querySelector(".flex-col");
    const teaserHTML = `
      <div class="col xs-12 m-4">
        <a href="https://bulbapedia.bulbagarden.net/wiki/${data.name}_(Pokémon)" target="_blank" class="pokemon-element-teaser layout-0 category-${data.category.id}">
          <div class="overlay">
            <span class="id-block">#${data.id}</span>
          </div>
          <div class="teaser-top-block">
            <span class="name">${data.name}</span>
            <span class="tag">${data.category.name}</span>
          </div>
          <div class="teaser-image-block">
            <img src="${data.image.big}" alt="${data.name}">
          </div>
          <span class="details-button">Details</span>
        </a>
      </div>
      `;
    colBlock.innerHTML += teaserHTML;
  },

  getRandomPokemon: () => {
    const pokemonArray = [];
    const pMax = 807; // thats the limit on local images we have atm @todo
    const randomNumArray = [
    Pokemon.randomPokeNum(1, pMax),
    Pokemon.randomPokeNum(1, pMax),
    Pokemon.randomPokeNum(1, pMax)];

    P.getPokemonByName(randomNumArray).then(response => {
      response.forEach(item => {
        Pokemon.createPokemonTeaserElement(Pokemon.createPokemonObject(item));
      });
    });
  },

  randomPokeNum: (min, max) =>
  Math.floor(Math.random() * (max - min + 1) + min),

  createPokemonObject: item => {
    const zeroId = `000${item.id}`.slice(-3);
    // get images from: https://github.com/HybridShivam/Pokemon
    // because sprits are not that nice
    const imageUrl = `https://raw.githubusercontent.com/HybridShivam/Pokemon/master/assets/images/${zeroId}.png`;
    const pokemon = {
      sId: item.id,
      id: zeroId,
      name: item.name,
      category: {
        id: Pokemon.getCategoryId(item.types[0].type.name),
        name: item.types[0].type.name },

      link: "/",
      image: {
        big: imageUrl } };


    return pokemon;
  },

  getCategoryId: category => {
    switch (category) {
      case "normal":
        return 1;
      case "fighting":
        return 2;
      case "flying":
        return 3;
      case "poison":
        return 4;
      case "ground":
        return 5;
      case "rock":
        return 6;
      case "bug":
        return 7;
      case "ghost":
        return 8;
      case "steel":
        return 9;
      case "fire":
        return 10;
      case "water":
        return 11;
      case "grass":
        return 12;
      case "electric":
        return 13;
      case "psychic":
        return 14;
      case "ice":
        return 15;
      case "dragon":
        return 16;
      case "dark":
        return 17;
      case "fairy":
        return 18;
      case "unknown":
        return 19;
      case "shadow":
        return 20;
      default:
        return 0;}

  } };


pageReady(() => {
  Pokemon.init();
});