document.addEventListener('DOMContentLoaded', function () {
    const cookieBanner = document.getElementById('cookie-banner');
    const toggleBannerButton = document.getElementById('toggle-banner');
    const acceptCookiesButton = document.getElementById('accept-cookies');
    const customizeCookiesButton = document.getElementById('customize-cookies');
    const rejectCookiesButton = document.getElementById('reject-cookies');
    const saveCookiesButton = document.getElementById('save-cookies');
    const cookieCustomize = document.getElementById('cookie-customize');
    const youtubeCookiesCheckbox = document.getElementById('youtube-cookies');
    const googleCookiesCheckbox = document.getElementById('google-cookies');
    const youtubeVideo = document.getElementById('youtube-video');
    const googleMaps = document.getElementById('google-maps');

    // Funktionen zum Anzeigen je nach gespeicherter Zustimmung
    function applySavedPreferences() {
        const cookieSettings = JSON.parse(sessionStorage.getItem('cookiePreferences'));
        if (!cookieSettings) {
            cookieBanner.classList.add('show');
            return;
        }

        cookieBanner.classList.remove('show');

        if (cookieSettings.youtube) {
            youtubeVideo.style.display = 'block';
            youtubeCookiesCheckbox.checked = true;
        } else {
            youtubeVideo.style.display = 'none';
        }

        if (cookieSettings.google) {
            googleMaps.style.display = 'block';
            googleCookiesCheckbox.checked = true;
        } else {
            googleMaps.style.display = 'none';
        }
    }

    // Initial prüfen, ob bereits Einstellungen existieren
    applySavedPreferences();
    toggleBannerButton.addEventListener('click', function () {
        cookieBanner.classList.toggle('show');
    });
    

    acceptCookiesButton.addEventListener('click', function () {
        const preferences = {
            youtube: true,
            google: true
        };
        sessionStorage.setItem('cookiePreferences', JSON.stringify(preferences));
        applySavedPreferences();
    });

    customizeCookiesButton.addEventListener('click', function () {
        cookieCustomize.style.display = 'block';
    });

    rejectCookiesButton.addEventListener('click', function () {
        const preferences = {
            youtube: false,
            google: false
        };
        sessionStorage.setItem('cookiePreferences', JSON.stringify(preferences));
        applySavedPreferences();
    });

    saveCookiesButton.addEventListener('click', function () {
        const preferences = {
            youtube: youtubeCookiesCheckbox.checked,
            google: googleCookiesCheckbox.checked
        };
        sessionStorage.setItem('cookiePreferences', JSON.stringify(preferences));
        applySavedPreferences();
    });
});
