class ProgressBar {
  #progressBar;
  #progressList;
  #progressBarFill;
  #steps = {
    current: 0,
    min: 0,
    max: 0
  };

  constructor(ref) {
    if (!ref) {
      console.error(
        `Not found or there is no element with reference "${ref}".`
      );
      return;
    }
    this.#progressBar = document.querySelector(`.${ref}`);
    this.#progressList = this.#progressBar.querySelectorAll("li");
    if (this.#progressList.length <= 0) {
      console.error("Empty step list!");
      return;
    }

    this.#steps.max = this.#progressList.length;
    this.#progressBarFill = this.#createFillBar(this.#progressBar);
    this.#updateProgress();
  }

  #createFillBar(el) {
    let tempBarEl = document.createElement("div");
    tempBarEl.classList.add("bar");
    let tempFillEl = document.createElement("div");
    tempFillEl.classList.add("fill");
    tempBarEl.appendChild(tempFillEl);
    el.appendChild(tempBarEl);
    return tempFillEl;
  }

  #updateProgress() {
    let stepsCount = this.getStep();
    let percent = ((stepsCount - 1) / (this.#progressList.length - 1)) * 100;
    this.#progressBarFill.style.width = `${percent}%`;

    this.#progressList.forEach((el, idx) => {
      if (idx <= stepsCount - 1) el.classList.add("active");
      else el.classList.remove("active");
      el.classList.remove("current");
    });

    if (stepsCount !== this.getMaxStep())
      this.#progressList[stepsCount].classList.add("current");
  }

  prev() {
    if (this.getStep() > this.getMinStep()) {
      this.#setStep(this.getStep() - 1);
      this.#updateProgress();
    }
  }

  next() {
    if (this.getStep() < this.getMaxStep()) {
      this.#setStep(this.getStep() + 1);
      this.#updateProgress();
    }
  }

  // Getters
  getStep() {
    return this.#steps.current;
  }

  getMinStep() {
    return this.#steps.min;
  }

  getMaxStep() {
    return this.#steps.max;
  }

  // Setters
  #setStep(vle) {
    this.#steps.current = vle;
  }
}

const progressBar = new ProgressBar("progress-bar");