document.addEventListener('DOMContentLoaded', () => {
  const textInput = document.getElementById('textInput');
  const textDisplay = document.getElementById('textDisplay');
  let currentText = ''; // Tracks the text currently in the display

  textInput.addEventListener('input', () => {
    const newText = textInput.value;

    // Find the length of the common prefix between currentText and newText
    let i = 0;
    while (
      i < currentText.length &&
      i < newText.length &&
      currentText[i] === newText[i]
    ) {
      i++;
    }

    // Remove spans from the end if the new text is shorter
    while (textDisplay.children.length > i) {
      textDisplay.removeChild(textDisplay.lastChild);
    }

    // Add new spans for characters added to the input
    for (let j = i; j < newText.length; j++) {
      const span = document.createElement('span');
      span.className = 'animated-text'; // Optional: for styling or animation
      span.textContent = newText[j] === ' ' ? '\u00A0' : newText[j]; // Handle spaces
      textDisplay.appendChild(span);
    }

    // Update the current text to match the new input
    currentText = newText;
  });
});