const svg = document.getElementById("starField");
        
        function createStar() {
            const star = document.createElementNS("http://www.w3.org/2000/svg", "circle");
            const size = Math.random() * 3 + 2;
            const x = Math.random() * window.innerWidth;
            const y = -10;
            
            star.setAttribute("cx", x);
            star.setAttribute("cy", y);
            star.setAttribute("r", size);
            star.setAttribute("fill", "url(#neonGlow)");
            star.style.opacity = Math.random();
            
            svg.appendChild(star);
            
            const duration = Math.random() * 3 + 2;
            star.animate([
                { transform: `translateY(0px)`, opacity: 1 },
                { transform: `translateY(${window.innerHeight + 10}px)`, opacity: 0 }
            ], {
                duration: duration * 1000,
                easing: "linear",
                fill: "forwards"
            }).onfinish = () => star.remove();
        }
        
        function addGlowEffect() {
            const defs = document.createElementNS("http://www.w3.org/2000/svg", "defs");
            const filter = document.createElementNS("http://www.w3.org/2000/svg", "filter");
            filter.setAttribute("id", "glow");
            
            const feGaussianBlur = document.createElementNS("http://www.w3.org/2000/svg", "feGaussianBlur");
            feGaussianBlur.setAttribute("stdDeviation", "3.5");
            feGaussianBlur.setAttribute("result", "coloredBlur");
            
            const feMerge = document.createElementNS("http://www.w3.org/2000/svg", "feMerge");
            const feMergeNode1 = document.createElementNS("http://www.w3.org/2000/svg", "feMergeNode");
            feMergeNode1.setAttribute("in", "coloredBlur");
            const feMergeNode2 = document.createElementNS("http://www.w3.org/2000/svg", "feMergeNode");
            feMergeNode2.setAttribute("in", "SourceGraphic");
            
            feMerge.appendChild(feMergeNode1);
            feMerge.appendChild(feMergeNode2);
            filter.appendChild(feGaussianBlur);
            filter.appendChild(feMerge);
            defs.appendChild(filter);
            
            const radialGradient = document.createElementNS("http://www.w3.org/2000/svg", "radialGradient");
            radialGradient.setAttribute("id", "neonGlow");
            radialGradient.setAttribute("cx", "50%");
            radialGradient.setAttribute("cy", "50%");
            radialGradient.setAttribute("r", "50%");
            radialGradient.innerHTML = `
                <stop offset="0%" stop-color="#0ff" stop-opacity="1"/>
                <stop offset="100%" stop-color="#00f" stop-opacity="0"/>
            `;
            defs.appendChild(radialGradient);
            
            svg.appendChild(defs);
        }
        
        function generateStars() {
            setInterval(createStar, 200);
        }
        
        addGlowEffect();
        generateStars();