const slideTransforms = [
  'translate3d(-200%, -50%, 0rem) rotateY(45deg) scale(0.85)', 
  'translate3d(-150%, -50%, 3rem) rotateY(30deg) scale(0.9)', 
  'translate3d(-100%, -50%, 6rem) rotateY(15deg) scale(0.95)', 
  'translate3d(-50%, -50%, 9rem)', 
  'translate3d(0%, -50%, 6rem) rotateY(-15deg) scale(0.95)', 
  'translate3d(50%, -50%, 3rem) rotateY(-30deg) scale(0.9)', 
  'translate3d(100%, -50%, 0) rotateY(-45deg) scale(0.85)'
];

const slides = document.querySelectorAll('.slide');

// Initiale Zuweisung der Transforms für jede Folie
slides.forEach((slide, index) => {
  const slideTransform = slideTransforms[index];
  slide.style.transform = slideTransform;
});

let debounceTimeOut;

// Funktion zum Navigieren der Folien
const navigateTo = (next) => {
  clearTimeout(debounceTimeOut);

  debounceTimeOut = setTimeout(() => {
    // Die Reihenfolge der Folien ändern
    if (next) {
      slideTransforms.unshift(slideTransforms.pop());  // Neueste Folie nach vorne
    } else {
      slideTransforms.push(slideTransforms.shift());  // Letzte Folie nach hinten
    }

    // Aktualisiere die Transforms für jede Folie
    slides.forEach((slide, index) => {
      slide.style.transform = slideTransforms[index];
    });
  }, 500);
}

// Event Listener für Vor- und Zurück-Knöpfe
document.getElementById('prev-slide').addEventListener('click', () => navigateTo(false));
document.getElementById('nxt-slide').addEventListener('click', () => navigateTo(true));
