<?php
session_start();
require_once("config.php");

$id = $_SESSION['login_id'] ?? null;

if ($id) {
    $stmt = $db_connection->prepare("SELECT * FROM users WHERE google_id = ?");
    $stmt->bind_param("s", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    $row55 = $result->fetch_assoc();

    if ($row55) {
        $benutzername = htmlspecialchars($row55['name']);
      } else {
        echo "Kein Benutzer gefunden.";
      }
    } else {
      echo "Nicht eingeloggt.";
    }
?>


<!doctype html>
<html lang="en">

<head>

  <title>Kostenlose HTML-, CSS-, JavaScript-, MySQL- und PHP-Projekte – Download für deine Webentwicklung |
    coding.snapsta.net</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <meta name="description"
    content="Entdecke kostenlose Projekte und Skripte für HTML, CSS, PHP, JavaScript und MySQL. Ideal für Anfänger und Profis! Lade hochwertige Vorlagen für deine Webentwicklung herunter oder lerne mit unseren Tutorials.">
  <meta name="keywords"
    content="Webdesign, Animationen, kostenlose Downloads, Radio Buttons, Webentwicklung, Banner, Bootstrap, CSS, Fonts">
  <meta name="author" content="SystemsX - Webdesigner und Entwickler">
  <meta property="og:title" content="Kostenlose Web-Design Ressourcen | SystemsX">
  <meta property="og:description"
    content="Lade coole Animationen, Radio-Button-Bewertungen und mehr kostenlos herunter! Unterstütze kreative Web-Projekte.">
  <meta property="og:image" content="img/coole-anmiation-banner.PNG">
  <meta property="og:url" content="https://coding.snapsta.net">
  <meta property="og:type" content="website">
  <meta property="og:site_name" content="SystemsX Webdesign">
  <meta name="twitter:card" content="summary_large_image">
  <meta name="twitter:title" content="Kostenlose Web-Design Ressourcen | SystemsX">
  <meta name="twitter:description"
    content="Lade coole Animationen, Radio-Button-Bewertungen und mehr kostenlos herunter!">
  <meta name="twitter:image" content="img/coole-anmiation-banner.PNG">
  <link rel="icon" href="favicon.ico" type="image/x-icon">
  <link rel="canonical" href="https://coding.snapsta.net">
  <link rel="stylesheet" type="text/css" href="bootstrap/css/bootstrap.min.css">
  <link rel="stylesheet" type="text/css" href="bootstrap/css/bootstrap-grid.css">
  <link rel="stylesheet" type="text/css" href="css/normalize.css">
  <link rel="stylesheet" type="text/css" href="css/style.css">
  <link rel="stylesheet" type="text/css" href="style.css">
  <link rel="stylesheet" type="text/css" href="css/responsive.css">
  <link rel="stylesheet" type="text/css" href="font/web-font.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.10.2/css/all.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/meyer-reset/2.0/reset.min.css">
  <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Roboto:400,500,700&display=swap">
  <meta name="robots" content="index, follow">
  <meta name="google-adsense-account" content="ca-pub-2425735340297804">
  <meta name="theme-color" content="#ffffff">
  <meta name="rating" content="general">
  <meta name="revisit-after" content="7 days">
  <meta name="distribution" content="global">
  <meta name="language" content="de">
</head>


<body>
  <div class="main-container yoga-template">
    <div class="banner">
      <div class="banner-overlay"></div>
      <div class="inside-container top-bar">
        <div class="row">
          <div class="col-md-4 top-bar-left order-2 order-md-12">

            <a href="https://www.youtube.com/@systemsxtutorials">Mein YouTube Kanal</a>
          </div>
          <div class="col-md-4 logo order-1 order-md-12">
            <a href="index.html"><img class="logo-img" src="img/social_branding.png" width="100px" alt=""></a>
          </div>
          <div class="col-md-4 top-bar-right order-3 order-md-12">

            <a href="https://www.tinkstar.de">Tinkstar</a> |
            <a href="https://www.snapsta.net">snapsta</a>
          </div>
        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-md-4 top-bar-left order-2 order-md-12">
        <a href="logout.php">Ausloggen</a>
        <p><?php echo $benutzername; ?></p><br><br>

        <a href="location.php">Location Auslesen</a>


<?php
// IDs der beiden Benutzer, deren Entfernung du berechnen willst
$userId1 = 1; // z.B. Benutzer mit ID 1
$userId2 = 2; // z.B. Benutzer mit ID 2

// Benutzer 1 abrufen
$stmt1 = $conn->prepare("SELECT latitude, longitude, name FROM users WHERE id = ?");
$stmt1->bind_param("i", $userId1);
$stmt1->execute();
$result1 = $stmt1->get_result();

if ($result1->num_rows === 0) {
    die("Benutzer 1 nicht gefunden.");
}
$user1 = $result1->fetch_assoc();

// Benutzer 2 abrufen
$stmt2 = $conn->prepare("SELECT latitude, longitude, name FROM users WHERE id = ?");
$stmt2->bind_param("i", $userId2);
$stmt2->execute();
$result2 = $stmt2->get_result();

if ($result2->num_rows === 0) {
    die("Benutzer 2 nicht gefunden.");
}
$user2 = $result2->fetch_assoc();

// Funktion zur Entfernung mit Haversine-Formel (km)
function haversineDistance($lat1, $lon1, $lat2, $lon2) {
    $earthRadius = 6371; // Erdradius in km

    // Umwandlung Grad zu Radiant
    $lat1 = deg2rad(floatval($lat1));
    $lon1 = deg2rad(floatval($lon1));
    $lat2 = deg2rad(floatval($lat2));
    $lon2 = deg2rad(floatval($lon2));

    $dLat = $lat2 - $lat1;
    $dLon = $lon2 - $lon1;

    $a = sin($dLat / 2) * sin($dLat / 2) +
         cos($lat1) * cos($lat2) *
         sin($dLon / 2) * sin($dLon / 2);

    $c = 2 * atan2(sqrt($a), sqrt(1 - $a));
    $distance = $earthRadius * $c;

    return $distance; // in km
}

$distanceKm = haversineDistance($user1['latitude'], $user1['longitude'], $user2['latitude'], $user2['longitude']);
$distanceMeters = round($distanceKm * 1000);

echo "Entfernung zwischen " . htmlspecialchars($user1['name']) . " und " . htmlspecialchars($user2['name']) . ":<br>";
echo round($distanceKm, 4) . " km / " . $distanceMeters . " Meter";

$stmt1->close();
$stmt2->close();
$conn->close();
?>


      </div>
      <div class="col-md-4 logo order-1 order-md-12">

      </div>
      <div class="col-md-4 top-bar-right order-3 order-md-12">


      </div>
    </div>
  </div>


</body>

</html>