<?php
session_start();
require_once("config.php");

// Überprüfen, ob der Benutzer eingeloggt ist
if (!isset($_SESSION['login_id'])) {
    die("Fehler: Kein Benutzer eingeloggt.");
}

// JSON-Daten aus dem Request lesen
$data = json_decode(file_get_contents("php://input"), true);

if (isset($data['latitude']) && isset($data['longitude']) && isset($data['city'])) {
    $latitude = $data['latitude'];
    $longitude = $data['longitude'];
    $city = $data['city'];
    $google_id = $_SESSION['login_id'];

    // Prepare statement mit ? Platzhaltern
    $stmt = $pdo->prepare("UPDATE users SET latitude = ?, longitude = ?, stadt = ? WHERE google_id = ?");

    if ($stmt === false) {
        die("Fehler bei prepare(): " . $pdo->error);
    }

    // Parameter binden: ddss = double, double, string, string
    $stmt->bind_param("ddss", $latitude, $longitude, $city, $google_id);

    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            echo "Standortdaten erfolgreich aktualisiert.";
        } else {
            echo "Kein Eintrag aktualisiert (eventuell keine Änderungen).";
        }
    } else {
        echo "Fehler bei Ausführung: " . $stmt->error;
    }

    $stmt->close();
} else {
    echo "Fehler: Ungültige Daten.";
}
?>
