<?php
session_start();
require 'config.php';



require 'google-api/vendor/autoload.php';

$client = new Google_Client();
$client->setClientId('293893751686-6sk74h9834f330o83u1usoj50h8u1p1l.apps.googleusercontent.com');
$client->setClientSecret('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');
$client->setRedirectUri('http://localhost/location_auslesen/lets_code/login.php');
$client->addScope("email");
$client->addScope("profile");

if (isset($_GET['code'])) {
    $token = $client->fetchAccessTokenWithAuthCode($_GET['code']);

    if (!isset($token["error"])) {
        $client->setAccessToken($token['access_token']);

        $google_oauth = new Google_Service_Oauth2($client);
        $google_account_info = $google_oauth->userinfo->get();

        $id = mysqli_real_escape_string($db_connection, $google_account_info->id);
        $full_name = mysqli_real_escape_string($db_connection, trim($google_account_info->name));
        $email = mysqli_real_escape_string($db_connection, $google_account_info->email);
        $profile_pic = mysqli_real_escape_string($db_connection, $google_account_info->picture);

        $stmt = mysqli_prepare($db_connection, "SELECT `google_id` FROM `users` WHERE `google_id` = ?");
        mysqli_stmt_bind_param($stmt, "s", $id);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_store_result($stmt);

        if (mysqli_stmt_num_rows($stmt) > 0) {
            $_SESSION['login_id'] = $id;
            header('Location: index.php');
            exit;
        } else {
            $insert = mysqli_prepare($db_connection, "INSERT INTO `users`(`google_id`,`name`,`email`,`profile_image`) VALUES (?, ?, ?, ?)");
            mysqli_stmt_bind_param($insert, "ssss", $id, $full_name, $email, $profile_pic);
            if (mysqli_stmt_execute($insert)) {
                $_SESSION['login_id'] = $id;
                header('Location: index.php');
                exit;
            } else {
                echo "Sign up failed! (Etwas ist schief gelaufen.)";
            }
        }
    } else {
        header('Location: index.php');
        exit;
    }
} else {
    $login_url = $client->createAuthUrl();
    ?>

<!DOCTYPE html>
<html lang="de">

<head>
    <meta charset="UTF-8">
    <title>Login - Tinkstar</title>
    <style>
        /* Dein CSS bleibt wie gehabt */
    </style>
</head>

<body>
    <div class="_container">
        <h2 class="heading">Login</h2>
    </div>
    <div class="_container btn">
        <a type="button" class="login-with-google-btn" href="<?php echo htmlspecialchars($login_url); ?>">
            Sign in with Google
        </a>
    </div>
</body>

</html>

<?php } ?>