<?php
// === DB CONFIG (edit this) ===
$DB_HOST = "localhost";
$DB_NAME = "comment_system";
$DB_USER = "root";
$DB_PASS = "";

// === PDO ===
$dsn = "mysql:host={$DB_HOST};dbname={$DB_NAME};charset=utf8mb4";
$options = [
  PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
  PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
  PDO::ATTR_EMULATE_PREPARES => false,
];

try {
  $pdo = new PDO($dsn, $DB_USER, $DB_PASS, $options);
} catch (Throwable $e) {
  http_response_code(500);
  header("Content-Type: text/plain; charset=utf-8");
  echo "DB connection failed. Please check config.php\n\n" . $e->getMessage();
  exit;
}

function json_out($data, int $status=200): void {
  http_response_code($status);
  header("Content-Type: application/json; charset=utf-8");
  echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
  exit;
}

function client_ip(): string {
  // Basic best-effort
  if (!empty($_SERVER['HTTP_CF_CONNECTING_IP'])) return $_SERVER['HTTP_CF_CONNECTING_IP'];
  if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) return trim(explode(",", $_SERVER['HTTP_X_FORWARDED_FOR'])[0]);
  return $_SERVER['REMOTE_ADDR'] ?? "";
}

function load_forbidden_words(string $path): array {
  if (!is_file($path)) return [];
  $raw = file_get_contents($path);
  $arr = json_decode($raw, true);
  if (!is_array($arr)) return [];
  // normalize: lower, trim, remove empties, unique
  $out = [];
  foreach ($arr as $w) {
    if (!is_string($w)) continue;
    $w = mb_strtolower(trim($w), 'UTF-8');
    if ($w !== "") $out[$w] = true;
  }
  return array_keys($out);
}

function find_forbidden_hit(string $text, array $words): ?string {
  // Normalize text (keep letters/numbers), but we still do word-boundary check on original.
  $hay = mb_strtolower($text, 'UTF-8');

  foreach ($words as $w) {
    // Escape for regex
    $q = preg_quote($w, '/');

    // Match full word-like boundaries including umlauts (best effort)
    // We treat boundaries as: start/end OR non-letter/number/underscore.
    $pattern = '/(^|[^\p{L}\p{N}_])' . $q . '([^\p{L}\p{N}_]|$)/u';

    if (preg_match($pattern, $hay)) {
      return $w;
    }
  }
  return null;
}
