<?php
require_once __DIR__ . "/../config.php";

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  json_out(["ok" => false, "error" => "Method not allowed"], 405);
}

$input = $_POST;
if (empty($input)) {
  // handle JSON body
  $raw = file_get_contents("php://input");
  $j = json_decode($raw, true);
  if (is_array($j)) $input = $j;
}

$name = trim((string)($input["name"] ?? ""));
$message = trim((string)($input["message"] ?? ""));

if ($name === "" || $message === "") {
  json_out(["ok" => false, "error" => "Bitte Name und Nachricht ausfüllen."], 400);
}

if (mb_strlen($name, 'UTF-8') > 80) {
  json_out(["ok" => false, "error" => "Name ist zu lang (max 80 Zeichen)."], 400);
}
if (mb_strlen($message, 'UTF-8') > 2000) {
  json_out(["ok" => false, "error" => "Nachricht ist zu lang (max 2000 Zeichen)."], 400);
}

// Forbidden words check
$words = load_forbidden_words(__DIR__ . "/../forbidden_words.json");
$hit = find_forbidden_hit($message, $words);
if ($hit !== null) {
  json_out([
    "ok" => false,
    "error" => "Nachricht kann nicht abgeschickt werden wegen unangemessener Wortwahl.",
    "code" => "FORBIDDEN_WORD"
  ], 400);
}

// Insert
$stmt = $pdo->prepare("INSERT INTO comments (name, message, ip) VALUES (?, ?, ?)");
$stmt->execute([$name, $message, client_ip()]);

json_out(["ok" => true]);
